"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/**
 * Thrown when an object is not found.
 */
class NotFoundError extends Error {
  /**
   * Creates a new NotFoundError.
   *
   * @param {string} message - The error message.
   * @param {Error} params - Optional error properties.
   */
  constructor(message, ...params) {
    super(message, ...params);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, NotFoundError);
    }
    this.name = this.constructor.name;
    params = params || [];
    const error = params[0];
    if (error instanceof Error) {
      this.inner = error;
    }
  }
}
exports.default = NotFoundError;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJOb3RGb3VuZEVycm9yIiwiRXJyb3IiLCJjb25zdHJ1Y3RvciIsIm1lc3NhZ2UiLCJwYXJhbXMiLCJjYXB0dXJlU3RhY2tUcmFjZSIsIm5hbWUiLCJlcnJvciIsImlubmVyIiwiZXhwb3J0cyIsImRlZmF1bHQiLCJtb2R1bGUiXSwic291cmNlcyI6WyJub3RfZm91bmQuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBUaHJvd24gd2hlbiBhbiBvYmplY3QgaXMgbm90IGZvdW5kLlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBOb3RGb3VuZEVycm9yIGV4dGVuZHMgRXJyb3Ige1xuICAvKipcbiAgICogQ3JlYXRlcyBhIG5ldyBOb3RGb3VuZEVycm9yLlxuICAgKlxuICAgKiBAcGFyYW0ge3N0cmluZ30gbWVzc2FnZSAtIFRoZSBlcnJvciBtZXNzYWdlLlxuICAgKiBAcGFyYW0ge0Vycm9yfSBwYXJhbXMgLSBPcHRpb25hbCBlcnJvciBwcm9wZXJ0aWVzLlxuICAgKi9cbiAgY29uc3RydWN0b3IobWVzc2FnZSwgLi4ucGFyYW1zKSB7XG4gICAgc3VwZXIobWVzc2FnZSwgLi4ucGFyYW1zKTtcblxuICAgIGlmIChFcnJvci5jYXB0dXJlU3RhY2tUcmFjZSkge1xuICAgICAgRXJyb3IuY2FwdHVyZVN0YWNrVHJhY2UodGhpcywgTm90Rm91bmRFcnJvcik7XG4gICAgfVxuXG4gICAgdGhpcy5uYW1lID0gdGhpcy5jb25zdHJ1Y3Rvci5uYW1lO1xuXG4gICAgcGFyYW1zID0gcGFyYW1zIHx8IFtdO1xuICAgIGNvbnN0IGVycm9yID0gcGFyYW1zWzBdO1xuXG4gICAgaWYgKGVycm9yIGluc3RhbmNlb2YgRXJyb3IpIHtcbiAgICAgIHRoaXMuaW5uZXIgPSBlcnJvcjtcbiAgICB9XG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ2UsTUFBTUEsYUFBYSxTQUFTQyxLQUFLLENBQUM7RUFDL0M7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0VBQ0VDLFdBQVdBLENBQUNDLE9BQU8sRUFBRSxHQUFHQyxNQUFNLEVBQUU7SUFDOUIsS0FBSyxDQUFDRCxPQUFPLEVBQUUsR0FBR0MsTUFBTSxDQUFDO0lBRXpCLElBQUlILEtBQUssQ0FBQ0ksaUJBQWlCLEVBQUU7TUFDM0JKLEtBQUssQ0FBQ0ksaUJBQWlCLENBQUMsSUFBSSxFQUFFTCxhQUFhLENBQUM7SUFDOUM7SUFFQSxJQUFJLENBQUNNLElBQUksR0FBRyxJQUFJLENBQUNKLFdBQVcsQ0FBQ0ksSUFBSTtJQUVqQ0YsTUFBTSxHQUFHQSxNQUFNLElBQUksRUFBRTtJQUNyQixNQUFNRyxLQUFLLEdBQUdILE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFFdkIsSUFBSUcsS0FBSyxZQUFZTixLQUFLLEVBQUU7TUFDMUIsSUFBSSxDQUFDTyxLQUFLLEdBQUdELEtBQUs7SUFDcEI7RUFDRjtBQUNGO0FBQUNFLE9BQUEsQ0FBQUMsT0FBQSxHQUFBVixhQUFBO0FBQUFXLE1BQUEsQ0FBQUYsT0FBQSxHQUFBQSxPQUFBLENBQUFDLE9BQUEifQ==